@extends('include.admindashboard')

@section('body')
 <div class="page-content">
    <div class="container">
      	<div class="gaps-1x mgb-0-5x d-lg-none d-none d-sm-block"></div>


        <div class="card content-area">
            <div class="card-innr">

                <div class="card-head d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">{{$decoder->name}} Data Plans </h4>
                    <a href="#" data-toggle="modal" data-target="#myAddModal" class="btn btn-sm btn-auto btn-outline btn-primary d-sm-inline-block"><em class="fas fa-plus"></em><span class="d-none d-sm-inline-block">Add New Plan</span></a>


<!-- Modal -->
<div id="myAddModal" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">Add New {{$decoder->name}} Data Plan</h4>
      </div>
      <div class="modal-body">
        <form role="form" method="POST" enctype="multipart/form-data" action="{{route('admin.addinternetplan',$decoder->code)}}">
                        {{ csrf_field() }}
                            <div class="row">

                                <div class="col-md-6">
                                    <div class="input-item input-with-label">
                                        <label class="input-item-label">Data Plan Name</label>
                                        <div class="input-wrap">
                                            <input class="input-bordered" placeholder="Data Plan Name" type="text" name="name" required>
                                        </div>
                                    </div>
                                </div>
                                 <div class="col-sm-6 col-lg-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Plan Code</label>
                                            <div class="input-wrap">
                                                <input class="input-bordered required number" name="data_id"  type="number" placeholder="Enter Plan Code" required>
                                            </div>
                                        </div>
                                    </div>

                                <div class="col-md-12">
                                    <div class="sap"></div>
                                </div>
                            </div>
                            <div class="bank-details pt-3">
                                <div class="row">
                                    <div class="col-sm-6 col-lg-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Plan Price</label>
                                            <div class="input-wrap">
                                                <input class="input-bordered required" name="fee" type="text" placeholder="Enter Plan Price" required>
                                            </div>
                                        </div>
                                    </div>
                                     <div class="col-sm-6 col-lg-6">
                                        <div class="input-item input-with-label">
                                            <label class="input-item-label">Reseller Price</label>
                                            <div class="input-wrap">
                                                <input class="input-bordered required" name="reseller" type="text" placeholder="Enter Reseller Price" required>
                                            </div>
                                        </div>
                                    </div>


                                </div>
                            </div>


      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
         <button class="btn btn-md btn-primary" type="submit">Add</button>
      </div>
       </form>
    </div>

  </div>
</div>


                 </div>
                                <div class="gaps-1x"></div>
                <div class="row guttar-vr-30px">

@foreach($network as $data)
                                        <div class="col-xl-4 col-md-6 col-12">
                        <div class="payment-card">
    <div class="payment-head">
        <div class="payment-logo">
            <img src="{{asset($decoder->image)}}" class="topbar-logo"  width="100" alt="Manual">
        </div>
        <div class="payment-action">
            <a href="javascript:void(0)" class="toggle-tigger rotate"><em class="ti ti-more-alt"></em></a>
            <div class="toggle-class dropdown-content dropdown-content-top-left">
                <ul class="dropdown-list">
                    <li><a href="{{route('admin.internetplanview',$data->id)}}">Update</a></li>
                    @if($data->status == 1)
                    <li><a href="{{route('admin.internetplandisable',$data->id)}}">Disable</a></li>
                    @else
                    <li><a href="{{route('admin.internetplanenable',$data->id)}}">Enabled</a></li>
                    @endif
                </ul>

            </div>
        </div>
    </div>
    <div class="payment-body">
        <h5 class="payment-title">{{$data->name}}</h5>
        <p class="payment-text">{{$decoder->slogan}}</p>
        @if($data->status == 1)
        <div class="payment-status payment-status-connected">
            <span class="payment-status-icon"><em class="ti ti-check"></em></span>
            <div class="payment-status-text">Plan Is Active</div>
        </div>
        @else
        <div class="payment-status payment-status-disabled">
            <span class="payment-status-icon"><em class="ti ti-close"></em></span>
            <div class="payment-status-text">Plan is Inactive</div>
        </div>

        @endif
            </div>
    <div class="payment-footer">
                <span class="payment-id-title">Regular Price</span>
        <span class="payment-id"> {{$basic->currency}}{{$data->cost}} </span>
            </div>
             <div class="payment-footer">
                <span class="payment-id-title">Reseller Price</span>
        <span class="payment-id"> {{$basic->currency}}{{$data->reseller}} </span>
            </div>
</div>
                    </div>
                                      @endforeach
                                    </div>
                <div class="gaps-0x"></div>
            </div>
        </div>
    </div>
</div>

@stop


